/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.memory;

import com.google.caliper.memory.Chain;
import com.google.caliper.memory.ObjectVisitor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;

public final class ObjectExplorer {
    static final Predicate<Chain> notEnumFieldsOrClasses = new Predicate<Chain>(){

        public boolean apply(Chain chain) {
            return !Enum.class.isAssignableFrom(chain.getValueType()) && !(chain.getValue() instanceof Class);
        }
    };
    static final Function<Chain, Object> chainToObject = new Function<Chain, Object>(){

        public Object apply(Chain chain) {
            return chain.getValue();
        }
    };

    private ObjectExplorer() {
    }

    public static <T> T exploreObject(Object rootObject, ObjectVisitor<T> visitor) {
        return ObjectExplorer.exploreObject(rootObject, visitor, EnumSet.noneOf(Feature.class));
    }

    public static <T> T exploreObject(Object rootObject, ObjectVisitor<T> visitor, EnumSet<Feature> features) {
        ArrayDeque<Chain> stack = new ArrayDeque<Chain>(32);
        if (rootObject != null) {
            stack.push(Chain.root(rootObject));
        }
        block6: while (!stack.isEmpty()) {
            Object childValue;
            Chain chain = (Chain)stack.pop();
            ObjectVisitor.Traversal traversal = visitor.visit(chain);
            switch (traversal) {
                case SKIP: {
                    continue block6;
                }
                case EXPLORE: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Object value = chain.getValue();
            Class<?> valueClass = value.getClass();
            if (valueClass.isArray()) {
                boolean isPrimitive = valueClass.getComponentType().isPrimitive();
                for (int i = Array.getLength(value) - 1; i >= 0; --i) {
                    childValue = Array.get(value, i);
                    if (isPrimitive) {
                        if (!features.contains((Object)Feature.VISIT_PRIMITIVES)) continue;
                        visitor.visit(chain.appendArrayIndex(i, childValue));
                        continue;
                    }
                    if (childValue == null) {
                        if (!features.contains((Object)Feature.VISIT_NULL)) continue;
                        visitor.visit(chain.appendArrayIndex(i, childValue));
                        continue;
                    }
                    stack.push(chain.appendArrayIndex(i, childValue));
                }
                continue;
            }
            for (Field field : Lists.reverse(ObjectExplorer.getAllFields(value))) {
                childValue = null;
                try {
                    childValue = field.get(value);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                if (childValue == null) {
                    if (!features.contains((Object)Feature.VISIT_NULL)) continue;
                    visitor.visit(chain.appendField(field, childValue));
                    continue;
                }
                boolean isPrimitive = field.getType().isPrimitive();
                Chain.FieldChain extendedChain = chain.appendField(field, childValue);
                if (isPrimitive) {
                    if (!features.contains((Object)Feature.VISIT_PRIMITIVES)) continue;
                    visitor.visit(extendedChain);
                    continue;
                }
                stack.push(extendedChain);
            }
        }
        return visitor.result();
    }

    private static List<Field> getAllFields(Object o) {
        ArrayList fields = Lists.newArrayListWithCapacity((int)8);
        for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : Arrays.asList(clazz.getDeclaredFields())) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        AccessibleObject.setAccessible(fields.toArray(new AccessibleObject[fields.size()]), true);
        return fields;
    }

    public static enum Feature {
        VISIT_NULL,
        VISIT_PRIMITIVES;

    }

    static class AtMostOncePredicate
    implements Predicate<Chain> {
        private final Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());

        AtMostOncePredicate() {
        }

        public boolean apply(Chain chain) {
            return this.seen.add(chain.getValue());
        }
    }
}

