/*
 ==============================================================================
 This file is part of the IEM plug-in suite.
 Author: Daniel Rudrich
 Copyright (c) 2017 - Institute of Electronic Music and Acoustics (IEM)
 https://iem.at

 The IEM plug-in suite is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 The IEM plug-in suite is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this software.  If not, see <https://www.gnu.org/licenses/>.
 ==============================================================================
 */

#ifndef interpLagrangeWeights_h
#define interpLagrangeWeights_h

#define interpLength 4
#define interpOffset 1
#define interpShift 7
#define interpMult 128
#define interpMask 127

const float lagrange_weights[129][4] = { {
                                             0.0f,
                                             1.0f,
                                             0.0f,
                                             0.0f,
                                         },
                                         {
                                             -0.0025737f,
                                             0.99603f,
                                             0.0078428f,
                                             -0.001302f,
                                         },
                                         {
                                             -0.0050869f,
                                             0.99195f,
                                             0.015745f,
                                             -0.0026035f,
                                         },
                                         {
                                             -0.00754f,
                                             0.98774f,
                                             0.023706f,
                                             -0.0039041f,
                                         },
                                         {
                                             -0.0099335f,
                                             0.98341f,
                                             0.031723f,
                                             -0.0052032f,
                                         },
                                         {
                                             -0.012268f,
                                             0.97897f,
                                             0.039796f,
                                             -0.0065005f,
                                         },
                                         {
                                             -0.014544f,
                                             0.97442f,
                                             0.047922f,
                                             -0.0077953f,
                                         },
                                         {
                                             -0.016761f,
                                             0.96975f,
                                             0.056101f,
                                             -0.0090873f,
                                         },
                                         {
                                             -0.018921f,
                                             0.96497f,
                                             0.064331f,
                                             -0.010376f,
                                         },
                                         {
                                             -0.021024f,
                                             0.96007f,
                                             0.072611f,
                                             -0.011661f,
                                         },
                                         {
                                             -0.023069f,
                                             0.95507f,
                                             0.080938f,
                                             -0.012941f,
                                         },
                                         {
                                             -0.025059f,
                                             0.94996f,
                                             0.089313f,
                                             -0.014217f,
                                         },
                                         {
                                             -0.026993f,
                                             0.94475f,
                                             0.097733f,
                                             -0.015488f,
                                         },
                                         {
                                             -0.028871f,
                                             0.93943f,
                                             0.1062f,
                                             -0.016752f,
                                         },
                                         {
                                             -0.030695f,
                                             0.934f,
                                             0.1147f,
                                             -0.018011f,
                                         },
                                         {
                                             -0.032464f,
                                             0.92848f,
                                             0.12325f,
                                             -0.019263f,
                                         },
                                         {
                                             -0.03418f,
                                             0.92285f,
                                             0.13184f,
                                             -0.020508f,
                                         },
                                         {
                                             -0.035842f,
                                             0.91713f,
                                             0.14046f,
                                             -0.021745f,
                                         },
                                         {
                                             -0.037451f,
                                             0.9113f,
                                             0.14912f,
                                             -0.022974f,
                                         },
                                         {
                                             -0.039007f,
                                             0.90538f,
                                             0.15782f,
                                             -0.024194f,
                                         },
                                         {
                                             -0.040512f,
                                             0.89937f,
                                             0.16655f,
                                             -0.025406f,
                                         },
                                         {
                                             -0.041965f,
                                             0.89326f,
                                             0.17531f,
                                             -0.026608f,
                                         },
                                         {
                                             -0.043367f,
                                             0.88706f,
                                             0.18411f,
                                             -0.0278f,
                                         },
                                         {
                                             -0.044719f,
                                             0.88077f,
                                             0.19293f,
                                             -0.028981f,
                                         },
                                         {
                                             -0.046021f,
                                             0.87439f,
                                             0.20178f,
                                             -0.030151f,
                                         },
                                         {
                                             -0.047272f,
                                             0.86792f,
                                             0.21066f,
                                             -0.03131f,
                                         },
                                         {
                                             -0.048475f,
                                             0.86137f,
                                             0.21956f,
                                             -0.032457f,
                                         },
                                         {
                                             -0.049629f,
                                             0.85473f,
                                             0.22849f,
                                             -0.033592f,
                                         },
                                         {
                                             -0.050735f,
                                             0.84801f,
                                             0.23744f,
                                             -0.034714f,
                                         },
                                         {
                                             -0.051794f,
                                             0.8412f,
                                             0.24641f,
                                             -0.035822f,
                                         },
                                         {
                                             -0.052805f,
                                             0.83432f,
                                             0.2554f,
                                             -0.036917f,
                                         },
                                         {
                                             -0.053769f,
                                             0.82735f,
                                             0.26441f,
                                             -0.037997f,
                                         },
                                         {
                                             -0.054688f,
                                             0.82031f,
                                             0.27344f,
                                             -0.039063f,
                                         },
                                         {
                                             -0.05556f,
                                             0.81319f,
                                             0.28248f,
                                             -0.040113f,
                                         },
                                         {
                                             -0.056387f,
                                             0.806f,
                                             0.29153f,
                                             -0.041147f,
                                         },
                                         {
                                             -0.057169f,
                                             0.79874f,
                                             0.3006f,
                                             -0.042166f,
                                         },
                                         {
                                             -0.057907f,
                                             0.7914f,
                                             0.30968f,
                                             -0.043167f,
                                         },
                                         {
                                             -0.058601f,
                                             0.78399f,
                                             0.31876f,
                                             -0.044152f,
                                         },
                                         {
                                             -0.059252f,
                                             0.77651f,
                                             0.32786f,
                                             -0.045118f,
                                         },
                                         {
                                             -0.05986f,
                                             0.76896f,
                                             0.33696f,
                                             -0.046067f,
                                         },
                                         {
                                             -0.060425f,
                                             0.76135f,
                                             0.34607f,
                                             -0.046997f,
                                         },
                                         {
                                             -0.060948f,
                                             0.75368f,
                                             0.35518f,
                                             -0.047908f,
                                         },
                                         {
                                             -0.06143f,
                                             0.74594f,
                                             0.36429f,
                                             -0.0488f,
                                         },
                                         {
                                             -0.061871f,
                                             0.73813f,
                                             0.37341f,
                                             -0.049671f,
                                         },
                                         {
                                             -0.062271f,
                                             0.73027f,
                                             0.38252f,
                                             -0.050522f,
                                         },
                                         {
                                             -0.062631f,
                                             0.72235f,
                                             0.39163f,
                                             -0.051352f,
                                         },
                                         {
                                             -0.062952f,
                                             0.71437f,
                                             0.40074f,
                                             -0.05216f,
                                         },
                                         {
                                             -0.063234f,
                                             0.70633f,
                                             0.40985f,
                                             -0.052947f,
                                         },
                                         {
                                             -0.063477f,
                                             0.69824f,
                                             0.41895f,
                                             -0.053711f,
                                         },
                                         {
                                             -0.063681f,
                                             0.6901f,
                                             0.42804f,
                                             -0.054452f,
                                         },
                                         {
                                             -0.063848f,
                                             0.6819f,
                                             0.43712f,
                                             -0.05517f,
                                         },
                                         {
                                             -0.063978f,
                                             0.67366f,
                                             0.44619f,
                                             -0.055864f,
                                         },
                                         {
                                             -0.064072f,
                                             0.66536f,
                                             0.45525f,
                                             -0.056534f,
                                         },
                                         {
                                             -0.064129f,
                                             0.65702f,
                                             0.46429f,
                                             -0.057179f,
                                         },
                                         {
                                             -0.06415f,
                                             0.64863f,
                                             0.47332f,
                                             -0.057798f,
                                         },
                                         {
                                             -0.064136f,
                                             0.64019f,
                                             0.48234f,
                                             -0.058392f,
                                         },
                                         {
                                             -0.064087f,
                                             0.63171f,
                                             0.49133f,
                                             -0.05896f,
                                         },
                                         {
                                             -0.064004f,
                                             0.62319f,
                                             0.50031f,
                                             -0.059501f,
                                         },
                                         {
                                             -0.063887f,
                                             0.61463f,
                                             0.50927f,
                                             -0.060015f,
                                         },
                                         {
                                             -0.063736f,
                                             0.60603f,
                                             0.5182f,
                                             -0.060501f,
                                         },
                                         {
                                             -0.063553f,
                                             0.5974f,
                                             0.52711f,
                                             -0.060959f,
                                         },
                                         {
                                             -0.063337f,
                                             0.58872f,
                                             0.536f,
                                             -0.061388f,
                                         },
                                         {
                                             -0.063089f,
                                             0.58002f,
                                             0.54486f,
                                             -0.061789f,
                                         },
                                         {
                                             -0.06281f,
                                             0.57127f,
                                             0.5537f,
                                             -0.062159f,
                                         },
                                         {
                                             -0.0625f,
                                             0.5625f,
                                             0.5625f,
                                             -0.0625f,
                                         },
                                         {
                                             -0.062159f,
                                             0.5537f,
                                             0.57127f,
                                             -0.06281f,
                                         },
                                         {
                                             -0.061789f,
                                             0.54486f,
                                             0.58002f,
                                             -0.063089f,
                                         },
                                         {
                                             -0.061388f,
                                             0.536f,
                                             0.58872f,
                                             -0.063337f,
                                         },
                                         {
                                             -0.060959f,
                                             0.52711f,
                                             0.5974f,
                                             -0.063553f,
                                         },
                                         {
                                             -0.060501f,
                                             0.5182f,
                                             0.60603f,
                                             -0.063736f,
                                         },
                                         {
                                             -0.060015f,
                                             0.50927f,
                                             0.61463f,
                                             -0.063887f,
                                         },
                                         {
                                             -0.059501f,
                                             0.50031f,
                                             0.62319f,
                                             -0.064004f,
                                         },
                                         {
                                             -0.05896f,
                                             0.49133f,
                                             0.63171f,
                                             -0.064087f,
                                         },
                                         {
                                             -0.058392f,
                                             0.48234f,
                                             0.64019f,
                                             -0.064136f,
                                         },
                                         {
                                             -0.057798f,
                                             0.47332f,
                                             0.64863f,
                                             -0.06415f,
                                         },
                                         {
                                             -0.057179f,
                                             0.46429f,
                                             0.65702f,
                                             -0.064129f,
                                         },
                                         {
                                             -0.056534f,
                                             0.45525f,
                                             0.66536f,
                                             -0.064072f,
                                         },
                                         {
                                             -0.055864f,
                                             0.44619f,
                                             0.67366f,
                                             -0.063978f,
                                         },
                                         {
                                             -0.05517f,
                                             0.43712f,
                                             0.6819f,
                                             -0.063848f,
                                         },
                                         {
                                             -0.054452f,
                                             0.42804f,
                                             0.6901f,
                                             -0.063681f,
                                         },
                                         {
                                             -0.053711f,
                                             0.41895f,
                                             0.69824f,
                                             -0.063477f,
                                         },
                                         {
                                             -0.052947f,
                                             0.40985f,
                                             0.70633f,
                                             -0.063234f,
                                         },
                                         {
                                             -0.05216f,
                                             0.40074f,
                                             0.71437f,
                                             -0.062952f,
                                         },
                                         {
                                             -0.051352f,
                                             0.39163f,
                                             0.72235f,
                                             -0.062631f,
                                         },
                                         {
                                             -0.050522f,
                                             0.38252f,
                                             0.73027f,
                                             -0.062271f,
                                         },
                                         {
                                             -0.049671f,
                                             0.37341f,
                                             0.73813f,
                                             -0.061871f,
                                         },
                                         {
                                             -0.0488f,
                                             0.36429f,
                                             0.74594f,
                                             -0.06143f,
                                         },
                                         {
                                             -0.047908f,
                                             0.35518f,
                                             0.75368f,
                                             -0.060948f,
                                         },
                                         {
                                             -0.046997f,
                                             0.34607f,
                                             0.76135f,
                                             -0.060425f,
                                         },
                                         {
                                             -0.046067f,
                                             0.33696f,
                                             0.76896f,
                                             -0.05986f,
                                         },
                                         {
                                             -0.045118f,
                                             0.32786f,
                                             0.77651f,
                                             -0.059252f,
                                         },
                                         {
                                             -0.044152f,
                                             0.31876f,
                                             0.78399f,
                                             -0.058601f,
                                         },
                                         {
                                             -0.043167f,
                                             0.30968f,
                                             0.7914f,
                                             -0.057907f,
                                         },
                                         {
                                             -0.042166f,
                                             0.3006f,
                                             0.79874f,
                                             -0.057169f,
                                         },
                                         {
                                             -0.041147f,
                                             0.29153f,
                                             0.806f,
                                             -0.056387f,
                                         },
                                         {
                                             -0.040113f,
                                             0.28248f,
                                             0.81319f,
                                             -0.05556f,
                                         },
                                         {
                                             -0.039063f,
                                             0.27344f,
                                             0.82031f,
                                             -0.054687f,
                                         },
                                         {
                                             -0.037997f,
                                             0.26441f,
                                             0.82735f,
                                             -0.053769f,
                                         },
                                         {
                                             -0.036917f,
                                             0.2554f,
                                             0.83432f,
                                             -0.052805f,
                                         },
                                         {
                                             -0.035822f,
                                             0.24641f,
                                             0.8412f,
                                             -0.051794f,
                                         },
                                         {
                                             -0.034714f,
                                             0.23744f,
                                             0.84801f,
                                             -0.050735f,
                                         },
                                         {
                                             -0.033592f,
                                             0.22849f,
                                             0.85473f,
                                             -0.049629f,
                                         },
                                         {
                                             -0.032457f,
                                             0.21956f,
                                             0.86137f,
                                             -0.048475f,
                                         },
                                         {
                                             -0.03131f,
                                             0.21066f,
                                             0.86792f,
                                             -0.047272f,
                                         },
                                         {
                                             -0.030151f,
                                             0.20178f,
                                             0.87439f,
                                             -0.046021f,
                                         },
                                         {
                                             -0.028981f,
                                             0.19293f,
                                             0.88077f,
                                             -0.044719f,
                                         },
                                         {
                                             -0.0278f,
                                             0.18411f,
                                             0.88706f,
                                             -0.043367f,
                                         },
                                         {
                                             -0.026608f,
                                             0.17531f,
                                             0.89326f,
                                             -0.041965f,
                                         },
                                         {
                                             -0.025406f,
                                             0.16655f,
                                             0.89937f,
                                             -0.040512f,
                                         },
                                         {
                                             -0.024194f,
                                             0.15782f,
                                             0.90538f,
                                             -0.039007f,
                                         },
                                         {
                                             -0.022974f,
                                             0.14912f,
                                             0.9113f,
                                             -0.037451f,
                                         },
                                         {
                                             -0.021745f,
                                             0.14046f,
                                             0.91713f,
                                             -0.035842f,
                                         },
                                         {
                                             -0.020508f,
                                             0.13184f,
                                             0.92285f,
                                             -0.03418f,
                                         },
                                         {
                                             -0.019263f,
                                             0.12325f,
                                             0.92848f,
                                             -0.032464f,
                                         },
                                         {
                                             -0.018011f,
                                             0.1147f,
                                             0.934f,
                                             -0.030695f,
                                         },
                                         {
                                             -0.016752f,
                                             0.1062f,
                                             0.93943f,
                                             -0.028871f,
                                         },
                                         {
                                             -0.015488f,
                                             0.097733f,
                                             0.94475f,
                                             -0.026993f,
                                         },
                                         {
                                             -0.014217f,
                                             0.089313f,
                                             0.94996f,
                                             -0.025059f,
                                         },
                                         {
                                             -0.012941f,
                                             0.080938f,
                                             0.95507f,
                                             -0.023069f,
                                         },
                                         {
                                             -0.011661f,
                                             0.072611f,
                                             0.96007f,
                                             -0.021024f,
                                         },
                                         {
                                             -0.010376f,
                                             0.064331f,
                                             0.96497f,
                                             -0.018921f,
                                         },
                                         {
                                             -0.0090873f,
                                             0.056101f,
                                             0.96975f,
                                             -0.016761f,
                                         },
                                         {
                                             -0.0077953f,
                                             0.047922f,
                                             0.97442f,
                                             -0.014544f,
                                         },
                                         {
                                             -0.0065005f,
                                             0.039796f,
                                             0.97897f,
                                             -0.012268f,
                                         },
                                         {
                                             -0.0052032f,
                                             0.031723f,
                                             0.98341f,
                                             -0.0099335f,
                                         },
                                         {
                                             -0.0039041f,
                                             0.023706f,
                                             0.98774f,
                                             -0.00754f,
                                         },
                                         {
                                             -0.0026035f,
                                             0.015745f,
                                             0.99195f,
                                             -0.0050869f,
                                         },
                                         {
                                             -0.001302f,
                                             0.0078428f,
                                             0.99603f,
                                             -0.0025737f,
                                         },
                                         {
                                             0.0f,
                                             0.0f,
                                             1.0f,
                                             0.0f,
                                         } };

// idx is the 7-bit-quantized fraction of your sample delay time , whereas fraction yields the fraction between two consecutive idx-values //TODO: write this text more understandable

#if JUCE_USE_SSE_INTRINSICS
__m128 inline getInterpolatedLagrangeWeights (int idx, float fraction)
{
    __m128 lowPart = _mm_set1_ps (1.0f - fraction);
    __m128 highPart = _mm_set1_ps (fraction);
    __m128 interp = _mm_add_ps (_mm_mul_ps (lowPart, _mm_loadu_ps (lagrange_weights[idx])),
                                _mm_mul_ps (highPart, _mm_loadu_ps (lagrange_weights[idx + 1])));
    return interp;
}
#endif /* JUCE_USE_SSE_INTRINSICS */

inline void getInterpolatedLagrangeWeights (int idx, float fraction, float out[4])
{
    float fraction_ = 1.0f - fraction;
    const float* A = lagrange_weights[idx];
    const float* B = lagrange_weights[idx + 1];
    for (int i = 0; i < 4; i++)
        out[i] = A[i] * fraction_ + B[i] * fraction;
}

#endif /* interpLagrangeWeights_h */
