/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller;

import jarinstaller.ErrorHandler;
import jarinstaller.gui.DebugInfo;
import jarinstaller.gui.FileUtil;
import jarinstaller.gui.IReport;
import jarinstaller.oshandler.IOsHandler;
import jarinstaller.oshandler.OsFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtil
implements Runnable {
    public static final String JAR_PATH_SEPARATOR = "/";
    private boolean debugOn = false;
    private volatile boolean stop = false;
    private volatile boolean stopped = false;
    private Hashtable items = null;
    private String path = null;
    private String jarfile = null;
    private JarFile jf;
    private boolean isurl = false;
    private URL url = null;
    private URI uri = null;
    private ErrorHandler err = new ErrorHandler(this.debugOn);
    private IReport report;
    private FileUtil fu = new FileUtil();
    private Vector extractedDirs;
    private Vector extractedFiles;
    private Hashtable gp;
    Hashtable dest = null;

    public JarUtil(URI uri) throws Exception {
        this.uri = uri;
        try {
            this.url = uri.toURL();
            String protocol = this.url.getProtocol().toLowerCase();
            this.isurl = false;
            if (protocol.indexOf("http") > -1 || protocol.indexOf("ftp") > -1) {
                this.isurl = true;
            } else if (this.url.toString().toLowerCase().indexOf("file") == 0) {
                this.isurl = true;
            }
            this.jarfile = this.url.getPath();
            this.path = uri.getPath();
            DebugInfo.showMessage("uri = " + uri);
            DebugInfo.showMessage("url = " + this.url);
            DebugInfo.showMessage("isurl = " + this.isurl);
            DebugInfo.showMessage("jarfile = " + this.jarfile);
            DebugInfo.showMessage("path = " + this.path);
            this.init();
        }
        catch (Exception e) {
            throw new Exception(this.err.errAdmin("15000", "JAR file olvas\u00e1si hiba", e, this.jarfile));
        }
    }

    public boolean isIsurl() {
        return this.isurl;
    }

    public boolean contains(String key) {
        if (this.items == null) {
            this.items = new Hashtable();
            this.list();
        }
        return this.items.containsKey(key);
    }

    public void close() {
        try {
            if (this.jf != null) {
                this.jf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        URL jarurl = null;
        try {
            if (this.isurl) {
                jarurl = new URL("jar:" + this.url + "!/");
                DebugInfo.showMessage("jarurl = " + jarurl);
                JarURLConnection jarConnection = (JarURLConnection)jarurl.openConnection();
                this.jf = jarConnection.getJarFile();
            } else {
                try {
                    this.jf = new JarFile(this.jarfile);
                }
                catch (IOException e) {
                    this.jf = new JarFile(this.path);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new Exception(this.err.errAdmin("15001", "Bels\u0151 hiba a JAR file olvas\u00e1sa k\u00f6zben", e, this.jarfile));
        }
        catch (IOException e) {
            throw new Exception(this.err.errAdmin("15002", "JAR file olvas\u00e1si hiba", e, this.jarfile));
        }
    }

    public int list() {
        int sum = 0;
        if (this.jf == null) {
            return sum;
        }
        if (this.items == null) {
            this.items = new Hashtable();
        }
        try {
            Enumeration<JarEntry> e = this.jf.entries();
            while (e.hasMoreElements()) {
                JarEntry ze = e.nextElement();
                int size = (int)ze.getSize();
                sum += size;
                this.items.put(ze.getName(), new Integer(size));
            }
            return sum;
        }
        catch (Exception e) {
            this.err.errAdmin("15003", "Hiba a JAR file list\u00e1z\u00e1sa sor\u00e1n", e, null);
            return 0;
        }
    }

    public long getElements() {
        return this.jf.size();
    }

    public byte[] getEntry(String name) {
        if (!this.contains(name)) {
            return null;
        }
        byte[] cf = null;
        JarEntry ze = this.jf.getJarEntry(name);
        if (ze != null) {
            InputStream jis = null;
            try {
                jis = this.jf.getInputStream(ze);
            }
            catch (IOException e) {
                this.err.errAdmin("15004", "JAR file olvas\u00e1si hiba", e, this.jarfile);
                return null;
            }
            cf = this.readInputStream(jis);
        }
        return cf;
    }

    private byte[] readInputStream(InputStream fis) {
        try {
            int lrb;
            int size = fis.available();
            byte[] b = new byte[size];
            int rb = 0;
            while (size - rb > 0 && (lrb = fis.read(b, rb, size - rb)) != -1) {
                rb += lrb;
                if (!this.stop) continue;
                throw new Exception(this.err.errAdmin("15012", "Megszak\u00edtva felhaszn\u00e1l\u00f3i beavatkoz\u00e1sra", null, ""));
            }
            fis.close();
            if (size == rb) {
                return b;
            }
            return null;
        }
        catch (Exception e) {
            this.err.errAdmin("15005", "JAR file olvas\u00e1si hiba", e, this.jarfile);
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public void extract(String destDir, IReport report) throws Exception {
        this.report = report;
        this.extract();
    }

    public void extract() throws Exception {
        if (this.report == null) {
            throw new Exception(this.err.errAdmin("15020", "Hi\u00e1nyos param\u00e9terek", null, null));
        }
        if (this.jf == null) {
            return;
        }
        try {
            Enumeration<JarEntry> e = this.jf.entries();
            while (e.hasMoreElements()) {
                JarEntry ze = e.nextElement();
                String en = ze.getName();
                File destFile = this.getFile(en);
                if (destFile == null) continue;
                this.report.inFormStart(en, destFile.getPath(), ze.getSize());
                this.extractFile(ze, destFile);
                this.report.inFormEnd(en, destFile.getPath(), ze.getSize());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.fu.remove(this.extractedFiles, this.extractedDirs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private File getFile(String fn) {
        Enumeration en = this.dest.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!fn.startsWith(key)) continue;
            String destPath = (String)this.dest.get(key);
            return new File(destPath + fn.substring(key.length()));
        }
        return null;
    }

    private void extractFile(JarEntry ze, File destFile) throws Exception {
        try {
            InputStream jis;
            byte[] data;
            if (ze.isDirectory()) {
                if (!destFile.exists()) {
                    this.mkDir(destFile);
                }
                return;
            }
            File dir = destFile.getParentFile();
            if (!dir.exists()) {
                this.mkDir(dir);
            }
            if ((data = this.readInputStream(jis = this.jf.getInputStream(ze))) == null) {
                throw new Exception(this.err.errAdmin("15010", "JAR file olvas\u00e1si hiba", null, destFile.getAbsolutePath()));
            }
            if (this.stop) {
                throw new Exception(this.err.errAdmin("15012", "Megszak\u00edtva felhaszn\u00e1l\u00f3i beavatkoz\u00e1sra", null, destFile.getAbsolutePath()));
            }
            this.writeFile(destFile, data);
            this.extractedFiles.add(destFile);
            if (this.stop) {
                throw new Exception(this.err.errAdmin("15012", "Megszak\u00edtva felhaszn\u00e1l\u00f3i beavatkoz\u00e1sra", null, destFile.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new Exception(this.err.errAdmin("15014", "Hiba a file kicsomagol\u00e1sa sor\u00e1n - " + e.getMessage(), e, destFile.getAbsolutePath()));
        }
    }

    private void mkDir(File dir) throws Exception {
        if (!dir.mkdirs()) {
            throw new Exception(this.err.errAdmin("15011", "Hiba a k\u00f6nyvt\u00e1r l\u00e9trehoz\u00e1sa sor\u00e1n", null, dir.getAbsolutePath()));
        }
        this.extractedDirs.add(dir);
    }

    private void writeFile(File file, byte[] data) throws Exception {
        FileOutputStream fout = null;
        try {
            if (file.exists() && !this.fu.removeFile(file)) {
                throw new Exception(this.err.errAdmin("15015", "Hiba a file l\u00e9trehoz\u00e1sa sor\u00e1n", null, file.getPath()));
            }
            fout = new FileOutputStream(file);
            if (fout == null) {
                throw new Exception(this.err.errAdmin("15015", "Hiba a file l\u00e9trehoz\u00e1sa sor\u00e1n", null, file.getPath()));
            }
            fout.write(data);
            fout.close();
        }
        catch (FileNotFoundException e) {
            throw new Exception(this.err.errAdmin("15016", "Hiba a file l\u00e9trehoz\u00e1sa sor\u00e1n", e, file.getPath()));
        }
        catch (IOException e) {
            try {
                if (fout != null) {
                    fout.close();
                }
                file.delete();
            }
            catch (Exception dm) {
                e.printStackTrace();
            }
            throw new Exception(this.err.errAdmin("15017", "Hiba a file \u00edr\u00e1sa sor\u00e1n", e, file.getPath()));
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.jarfile;
    }

    public URL getUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isItem(String key) {
        return this.items.containsKey(key);
    }

    public Enumeration getItems() {
        return this.items.elements();
    }

    public Vector getExtractedFiles() {
        return this.extractedFiles;
    }

    public void setReport(IReport report) {
        this.report = report;
    }

    public void setParams(Hashtable ht) {
        this.gp = ht;
    }

    public void run() {
        try {
            if (!this.readDestinations("copies")) {
                return;
            }
            this.initDataStore();
            this.extract();
            this.setFileProtection();
            this.report.setResult(true, "", null);
        }
        catch (Exception e) {
            this.report.setResult(false, e.getMessage(), null);
        }
        this.stopped = true;
    }

    public boolean readDestinations(String node) {
        this.dest = new Hashtable();
        if (!this.gp.containsKey(node)) {
            return false;
        }
        Vector copies = (Vector)this.gp.get(node);
        try {
            for (int i = 0; i < copies.size(); ++i) {
                Hashtable ht = (Hashtable)copies.elementAt(i);
                String destdir = (String)ht.get("destdir");
                if (destdir.trim().length() == 0) continue;
                String jardir = (String)ht.get("jardir");
                this.dest.put(this.fu.replaceTokens(jardir, this.gp), this.fu.replaceTokens(destdir, this.gp));
            }
            return true;
        }
        catch (Exception e) {
            this.dest.clear();
            return false;
        }
    }

    public void initDataStore() {
        if (this.gp.containsKey("parameter.option.install.filelist")) {
            this.extractedFiles = (Vector)this.gp.get("parameter.option.install.filelist");
        } else {
            this.extractedFiles = new Vector();
            this.gp.put("parameter.option.install.filelist", this.extractedFiles);
        }
        if (this.gp.containsKey("parameter.option.install.dirlist")) {
            this.extractedDirs = (Vector)this.gp.get("parameter.option.install.dirlist");
        } else {
            this.extractedDirs = new Vector();
            this.gp.put("parameter.option.install.dirlist", this.extractedDirs);
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void setFileProtection() {
        String node = "protflags";
        this.dest = new Hashtable();
        try {
            IOsHandler os = OsFactory.getOsHandler();
            if (!this.gp.containsKey(node)) {
                return;
            }
            Vector copies = (Vector)this.gp.get(node);
            for (int i = 0; i < copies.size(); ++i) {
                String fname;
                File path;
                Hashtable ht = (Hashtable)copies.elementAt(i);
                String filename = (String)ht.get("filename");
                if (filename.trim().length() == 0 || !(path = new File(fname = this.fu.replaceTokens(filename.trim(), this.gp))).exists()) continue;
                os.setExecuteFlag(path.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

