# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# This label is used by screenreaders and other assistive technology to indicate
# to users how much of the video has been loaded from the network. It will be
# followed by the percentage of the video that has loaded (e.g. "Loading: 13%").
videocontrols-buffer-bar-label = ᱞᱟᱫᱮᱜ ᱠᱟᱱᱟ :
videocontrols-volume-control =
    .aria-label = ᱜᱚᱱᱚᱝ
videocontrols-closed-caption-button =
    .aria-label = ᱵᱚᱸᱫ ᱠᱮᱯᱥᱚᱱ

videocontrols-play-button =
    .aria-label = ᱠᱷᱮᱞᱮᱸᱱᱰ
videocontrols-pause-button =
    .aria-label = ᱛᱤᱝᱜᱩ
videocontrols-mute-button =
    .aria-label = ᱥᱟᱲᱮ ᱛᱷᱤᱨ
videocontrols-unmute-button =
    .aria-label = ᱥᱟᱲᱮ ᱨᱩᱣᱟᱹᱲ
videocontrols-enterfullscreen-button =
    .aria-label = ᱯᱩᱨᱟᱹ ᱥᱠᱨᱤᱱ
videocontrols-exitfullscreen-button =
    .aria-label = ᱯᱩᱨᱟᱹ ᱥᱠᱨᱤᱱ ᱠᱷᱚᱱ ᱵᱟᱦᱨᱮ ᱚᱰᱚᱠ ᱾
videocontrols-casting-button-label =
    .aria-label = ᱯᱚᱨᱫᱟ ᱨᱮ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
videocontrols-closed-caption-off =
    .offlabel = ᱵᱚᱸᱫᱚ

# This string is used as part of the Picture-in-Picture video toggle button when
# the mouse is hovering it.
videocontrols-picture-in-picture-label = ᱪᱤᱛᱟᱹᱨᱼᱵᱷᱤᱛᱨᱤᱼᱪᱤᱛᱟᱹᱨ

# This string is used as the label for a variation of the Picture-in-Picture video
# toggle button when the mouse is hovering over the video.
videocontrols-picture-in-picture-toggle-label2 = ᱱᱚᱶᱟ ᱣᱤᱰᱤᱭᱚ ᱵᱟᱦᱨᱮ ᱛᱮ ᱚᱰᱚᱠ ᱢᱮ

# This string is used as part of a variation of the Picture-in-Picture video toggle
# button. When using this variation, this string appears below the toggle when the
# mouse hovers the toggle.
videocontrols-picture-in-picture-explainer3 = ᱰᱷᱮᱨ ᱥᱠᱨᱤᱱ ᱡᱟᱹᱥᱛᱤ ᱢᱚᱡᱽ ᱾ ᱟᱢ ᱫᱚ ᱮᱴᱟᱜ ᱡᱤᱱᱤᱥ ᱠᱚᱨᱟᱣ ᱛᱩᱞᱩᱡ ᱱᱚᱶᱟ ᱣᱤᱰᱤᱭᱚᱠᱚ ᱮᱱᱮᱡ ᱪᱷᱚᱭ ᱢᱮ ᱾

videocontrols-error-aborted = ᱢᱤᱰᱤᱭᱚ ᱞᱟᱫᱮ ᱛᱤᱸᱜᱩᱭᱮᱱᱟ᱾
videocontrols-error-network = ᱢᱤᱰᱤᱭᱚ ᱠᱷᱮᱞᱚᱸᱰ ᱨᱩᱣᱟᱹᱲ ᱢᱤᱫ ᱱᱮᱴᱣᱟᱨᱠ ᱵᱷᱩᱞ ᱠᱟᱨᱚᱱ ᱛᱮ ᱟᱲᱟᱜ ᱦᱚᱪᱚ ᱠᱮᱫ ᱟ ᱾
videocontrols-error-decode = ᱢᱤᱰᱤᱭᱚ ᱵᱟᱝ ᱠᱷᱮᱞᱚᱸᱰ ᱦᱚᱪᱚ ᱫᱟᱲᱮᱭᱟᱜ ᱟ ᱪᱮᱫᱟᱜ ᱡᱮ ᱨᱮᱫ ᱨᱟᱹᱯᱩᱫ ᱜᱮᱭᱟ ᱾
videocontrols-error-src-not-supported = ᱢᱤᱰᱤᱭᱚ ᱛᱮᱭᱟᱨ ᱟᱨ ᱵᱟᱝ MIME ᱞᱮᱠᱟᱱ ᱫᱚ ᱵᱟᱝ ᱜᱚᱲᱚᱣᱟᱜ ᱠᱟᱱᱟ ᱾
videocontrols-error-no-source = ᱜᱚᱲᱚᱣᱟᱜ ᱛᱮᱭᱟᱨ ᱟᱨ MIME ᱞᱮᱠᱟᱱ ᱥᱟᱸᱣ ᱡᱟᱦᱟᱱ ᱢᱤᱰᱤᱭᱚ ᱵᱟᱭ ᱧᱟᱢ ᱞᱮᱱᱟ ᱾
videocontrols-error-generic = ᱢᱤᱰᱤᱭᱚ ᱥᱮᱛᱚᱸᱰ ᱨᱩᱣᱟᱲ ᱢᱤᱫ ᱵᱟᱝ ᱵᱟᱰᱟᱭ ᱵᱷᱩᱞ ᱠᱟᱨᱚᱱ ᱛᱮ ᱟᱲᱟᱜ ᱞᱮᱱᱟ᱾
videocontrols-status-picture-in-picture = ᱱᱚᱶᱟ ᱣᱤᱰᱤᱭᱚᱠᱚ ᱫᱚ ᱪᱤᱛᱟᱹᱨᱼᱵᱷᱤᱛᱨᱤᱼᱪᱤᱛᱟᱹᱨ ᱨᱮ ᱮᱱᱮᱡᱚᱜ ᱠᱟᱱᱟ ᱾

# This message shows the current position and total video duration
#
# Variables:
#   $position (String): The current media position
#   $duration (String): The total video duration
#
# For example, when at the 5 minute mark in a 6 hour long video,
# $position would be "5:00" and $duration would be "6:00:00", result
# string would be "5:00 / 6:00:00". Note that $duration is not always
# available. For example, when at the 5 minute mark in an unknown
# duration video, $position would be "5:00" and the string which is
# surrounded by <span> would be deleted, result string would be "5:00".
videocontrols-position-and-duration-labels = { $position }<span data-l10n-name="position-duration-format"> / { $duration }</span>

# This is a plain text version of the videocontrols-position-and-duration-labels
# string, used by screenreaders.
#
# Variables:
#   $position (String): The current media position
#   $duration (String): The total video duration
videocontrols-scrubber-position-and-duration =
    .aria-label = ᱚᱵᱚᱥᱛᱟ
    .aria-valuetext = { $position } / { $duration }
