/*
 * Copyright (c) 1997-1999, 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Mar 24 02:08:58 EST 2003 */

#include "fftw-int.h"
#include "fftw.h"

/* Generated by: /homee/stevenj/cvs/fftw/gensrc/genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 9 */

/*
 * This function contains 182 FP additions, 121 FP multiplications,
 * (or, 130 additions, 69 multiplications, 52 fused multiply/add),
 * 43 stack variables, and 72 memory accesses
 */
static const fftw_real K296198132 =
FFTW_KONST(+0.296198132726023843175338011893050938967728390);
static const fftw_real K813797681 =
FFTW_KONST(+0.813797681349373692844693217248393223289101568);
static const fftw_real K852868531 =
FFTW_KONST(+0.852868531952443209628250963940074071936020296);
static const fftw_real K150383733 =
FFTW_KONST(+0.150383733180435296639271897612501926072238258);
static const fftw_real K663413948 =
FFTW_KONST(+0.663413948168938396205421319635891297216863310);
static const fftw_real K556670399 =
FFTW_KONST(+0.556670399226419366452912952047023132968291906);
static const fftw_real K939692620 =
FFTW_KONST(+0.939692620785908384054109277324731469936208134);
static const fftw_real K342020143 =
FFTW_KONST(+0.342020143325668733044099614682259580763083368);
static const fftw_real K984807753 =
FFTW_KONST(+0.984807753012208059366743024589523013670643252);
static const fftw_real K173648177 =
FFTW_KONST(+0.173648177666930348851716626769314796000375677);
static const fftw_real K1_705737063 =
FFTW_KONST(+1.705737063904886419256501927880148143872040591);
static const fftw_real K300767466 =
FFTW_KONST(+0.300767466360870593278543795225003852144476517);
static const fftw_real K642787609 =
FFTW_KONST(+0.642787609686539326322643409907263432907559884);
static const fftw_real K766044443 =
FFTW_KONST(+0.766044443118978035202392650555416673935832457);
static const fftw_real K1_113340798 =
FFTW_KONST(+1.113340798452838732905825904094046265936583811);
static const fftw_real K1_326827896 =
FFTW_KONST(+1.326827896337876792410842639271782594433726619);
static const fftw_real K500000000 =
FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K866025403 =
FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K2_000000000 =
FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_732050807 =
FFTW_KONST(+1.732050807568877293527446341505872366942805254);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.43 2003/03/16 23:43:46 stevenj Exp $
 * $Id: fft.ml,v 1.44 2003/03/16 23:43:46 stevenj Exp $
 * $Id: to_c.ml,v 1.26 2003/03/16 23:43:46 stevenj Exp $
 */

void fftw_hc2hc_backward_9(fftw_real *A, const fftw_complex *W,
			   int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (9 * iostride);
     {
	  fftw_real tmp154;
	  fftw_real tmp182;
	  fftw_real tmp176;
	  fftw_real tmp161;
	  fftw_real tmp164;
	  fftw_real tmp159;
	  fftw_real tmp168;
	  fftw_real tmp179;
	  fftw_real tmp171;
	  fftw_real tmp180;
	  fftw_real tmp160;
	  fftw_real tmp165;
	  ASSERT_ALIGNED_DOUBLE;
	  {
	       fftw_real tmp175;
	       fftw_real tmp152;
	       fftw_real tmp153;
	       fftw_real tmp173;
	       fftw_real tmp174;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp174 = Y[-3 * iostride];
	       tmp175 = K1_732050807 * tmp174;
	       tmp152 = X[0];
	       tmp153 = X[3 * iostride];
	       tmp173 = tmp153 - tmp152;
	       tmp154 = tmp152 + (K2_000000000 * tmp153);
	       tmp182 = tmp175 - tmp173;
	       tmp176 = tmp173 + tmp175;
	  }
	  {
	       fftw_real tmp155;
	       fftw_real tmp158;
	       fftw_real tmp169;
	       fftw_real tmp167;
	       fftw_real tmp166;
	       fftw_real tmp170;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp155 = X[iostride];
	       tmp161 = Y[-iostride];
	       {
		    fftw_real tmp156;
		    fftw_real tmp157;
		    fftw_real tmp162;
		    fftw_real tmp163;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp156 = X[4 * iostride];
		    tmp157 = X[2 * iostride];
		    tmp158 = tmp156 + tmp157;
		    tmp169 = K866025403 * (tmp156 - tmp157);
		    tmp162 = Y[-2 * iostride];
		    tmp163 = Y[-4 * iostride];
		    tmp164 = tmp162 - tmp163;
		    tmp167 = K866025403 * (tmp162 + tmp163);
	       }
	       tmp159 = tmp155 + tmp158;
	       tmp166 = tmp155 - (K500000000 * tmp158);
	       tmp168 = tmp166 - tmp167;
	       tmp179 = tmp166 + tmp167;
	       tmp170 = tmp161 + (K500000000 * tmp164);
	       tmp171 = tmp169 + tmp170;
	       tmp180 = tmp170 - tmp169;
	  }
	  X[0] = tmp154 + (K2_000000000 * tmp159);
	  tmp160 = tmp154 - tmp159;
	  tmp165 = K1_732050807 * (tmp161 - tmp164);
	  X[6 * iostride] = tmp160 + tmp165;
	  X[3 * iostride] = tmp160 - tmp165;
	  {
	       fftw_real tmp177;
	       fftw_real tmp172;
	       fftw_real tmp178;
	       fftw_real tmp184;
	       fftw_real tmp181;
	       fftw_real tmp183;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp177 = (K1_326827896 * tmp171) + (K1_113340798 * tmp168);
	       tmp172 = (K766044443 * tmp168) - (K642787609 * tmp171);
	       tmp178 = tmp172 + tmp176;
	       X[iostride] = (K2_000000000 * tmp172) - tmp176;
	       X[7 * iostride] = tmp177 - tmp178;
	       X[4 * iostride] = -(tmp177 + tmp178);
	       tmp184 = (K300767466 * tmp180) + (K1_705737063 * tmp179);
	       tmp181 = (K173648177 * tmp179) - (K984807753 * tmp180);
	       tmp183 = tmp182 - tmp181;
	       X[2 * iostride] = (K2_000000000 * tmp181) + tmp182;
	       X[8 * iostride] = tmp184 + tmp183;
	       X[5 * iostride] = tmp183 - tmp184;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 8) {
	  fftw_real tmp44;
	  fftw_real tmp87;
	  fftw_real tmp135;
	  fftw_real tmp60;
	  fftw_real tmp107;
	  fftw_real tmp125;
	  fftw_real tmp49;
	  fftw_real tmp54;
	  fftw_real tmp55;
	  fftw_real tmp101;
	  fftw_real tmp109;
	  fftw_real tmp131;
	  fftw_real tmp137;
	  fftw_real tmp128;
	  fftw_real tmp136;
	  fftw_real tmp94;
	  fftw_real tmp108;
	  fftw_real tmp65;
	  fftw_real tmp70;
	  fftw_real tmp71;
	  ASSERT_ALIGNED_DOUBLE;
	  {
	       fftw_real tmp40;
	       fftw_real tmp56;
	       fftw_real tmp43;
	       fftw_real tmp105;
	       fftw_real tmp59;
	       fftw_real tmp86;
	       fftw_real tmp85;
	       fftw_real tmp106;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp40 = X[0];
	       tmp56 = Y[0];
	       {
		    fftw_real tmp41;
		    fftw_real tmp42;
		    fftw_real tmp57;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp41 = X[3 * iostride];
		    tmp42 = Y[-6 * iostride];
		    tmp43 = tmp41 + tmp42;
		    tmp105 = K866025403 * (tmp41 - tmp42);
		    tmp57 = Y[-3 * iostride];
		    tmp58 = X[6 * iostride];
		    tmp59 = tmp57 - tmp58;
		    tmp86 = K866025403 * (tmp57 + tmp58);
	       }
	       tmp44 = tmp40 + tmp43;
	       tmp85 = tmp40 - (K500000000 * tmp43);
	       tmp87 = tmp85 - tmp86;
	       tmp135 = tmp85 + tmp86;
	       tmp60 = tmp56 + tmp59;
	       tmp106 = tmp56 - (K500000000 * tmp59);
	       tmp107 = tmp105 + tmp106;
	       tmp125 = tmp106 - tmp105;
	  }
	  {
	       fftw_real tmp45;
	       fftw_real tmp48;
	       fftw_real tmp88;
	       fftw_real tmp91;
	       fftw_real tmp61;
	       fftw_real tmp64;
	       fftw_real tmp89;
	       fftw_real tmp92;
	       fftw_real tmp50;
	       fftw_real tmp53;
	       fftw_real tmp95;
	       fftw_real tmp98;
	       fftw_real tmp66;
	       fftw_real tmp69;
	       fftw_real tmp96;
	       fftw_real tmp99;
	       ASSERT_ALIGNED_DOUBLE;
	       {
		    fftw_real tmp46;
		    fftw_real tmp47;
		    fftw_real tmp62;
		    fftw_real tmp63;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp45 = X[iostride];
		    tmp46 = X[4 * iostride];
		    tmp47 = Y[-7 * iostride];
		    tmp48 = tmp46 + tmp47;
		    tmp88 = tmp45 - (K500000000 * tmp48);
		    tmp91 = K866025403 * (tmp46 - tmp47);
		    tmp61 = Y[-iostride];
		    tmp62 = Y[-4 * iostride];
		    tmp63 = X[7 * iostride];
		    tmp64 = tmp62 - tmp63;
		    tmp89 = K866025403 * (tmp62 + tmp63);
		    tmp92 = tmp61 - (K500000000 * tmp64);
	       }
	       {
		    fftw_real tmp51;
		    fftw_real tmp52;
		    fftw_real tmp67;
		    fftw_real tmp68;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp50 = X[2 * iostride];
		    tmp51 = Y[-5 * iostride];
		    tmp52 = Y[-8 * iostride];
		    tmp53 = tmp51 + tmp52;
		    tmp95 = tmp50 - (K500000000 * tmp53);
		    tmp98 = K866025403 * (tmp51 - tmp52);
		    tmp66 = Y[-2 * iostride];
		    tmp67 = X[5 * iostride];
		    tmp68 = X[8 * iostride];
		    tmp69 = tmp67 + tmp68;
		    tmp96 = K866025403 * (tmp67 - tmp68);
		    tmp99 = tmp66 + (K500000000 * tmp69);
	       }
	       tmp49 = tmp45 + tmp48;
	       tmp54 = tmp50 + tmp53;
	       tmp55 = tmp49 + tmp54;
	       {
		    fftw_real tmp97;
		    fftw_real tmp100;
		    fftw_real tmp129;
		    fftw_real tmp130;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp97 = tmp95 + tmp96;
		    tmp100 = tmp98 + tmp99;
		    tmp101 = (K173648177 * tmp97) - (K984807753 * tmp100);
		    tmp109 = (K984807753 * tmp97) + (K173648177 * tmp100);
		    tmp129 = tmp95 - tmp96;
		    tmp130 = tmp99 - tmp98;
		    tmp131 = (K342020143 * tmp129) - (K939692620 * tmp130);
		    tmp137 = (K939692620 * tmp129) + (K342020143 * tmp130);
	       }
	       {
		    fftw_real tmp126;
		    fftw_real tmp127;
		    fftw_real tmp90;
		    fftw_real tmp93;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp126 = tmp92 - tmp91;
		    tmp127 = tmp88 + tmp89;
		    tmp128 = (K173648177 * tmp126) + (K984807753 * tmp127);
		    tmp136 = (K173648177 * tmp127) - (K984807753 * tmp126);
		    tmp90 = tmp88 - tmp89;
		    tmp93 = tmp91 + tmp92;
		    tmp94 = (K766044443 * tmp90) - (K642787609 * tmp93);
		    tmp108 = (K766044443 * tmp93) + (K642787609 * tmp90);
		    tmp65 = tmp61 + tmp64;
		    tmp70 = tmp66 - tmp69;
		    tmp71 = tmp65 + tmp70;
	       }
	  }
	  X[0] = tmp44 + tmp55;
	  {
	       fftw_real tmp75;
	       fftw_real tmp81;
	       fftw_real tmp79;
	       fftw_real tmp83;
	       ASSERT_ALIGNED_DOUBLE;
	       {
		    fftw_real tmp73;
		    fftw_real tmp74;
		    fftw_real tmp77;
		    fftw_real tmp78;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp73 = tmp60 - (K500000000 * tmp71);
		    tmp74 = K866025403 * (tmp49 - tmp54);
		    tmp75 = tmp73 - tmp74;
		    tmp81 = tmp74 + tmp73;
		    tmp77 = tmp44 - (K500000000 * tmp55);
		    tmp78 = K866025403 * (tmp70 - tmp65);
		    tmp79 = tmp77 - tmp78;
		    tmp83 = tmp77 + tmp78;
	       }
	       {
		    fftw_real tmp72;
		    fftw_real tmp76;
		    fftw_real tmp80;
		    fftw_real tmp82;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp72 = c_re(W[5]);
		    tmp76 = c_im(W[5]);
		    Y[-2 * iostride] = (tmp72 * tmp75) - (tmp76 * tmp79);
		    X[6 * iostride] = (tmp76 * tmp75) + (tmp72 * tmp79);
		    tmp80 = c_re(W[2]);
		    tmp82 = c_im(W[2]);
		    Y[-5 * iostride] = (tmp80 * tmp81) - (tmp82 * tmp83);
		    X[3 * iostride] = (tmp82 * tmp81) + (tmp80 * tmp83);
	       }
	  }
	  Y[-8 * iostride] = tmp60 + tmp71;
	  {
	       fftw_real tmp114;
	       fftw_real tmp103;
	       fftw_real tmp117;
	       fftw_real tmp118;
	       fftw_real tmp111;
	       fftw_real tmp113;
	       fftw_real tmp102;
	       fftw_real tmp110;
	       fftw_real tmp84;
	       fftw_real tmp104;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp114 = K866025403 * (tmp94 - tmp101);
	       tmp102 = tmp94 + tmp101;
	       tmp103 = tmp87 + tmp102;
	       tmp117 = tmp87 - (K500000000 * tmp102);
	       tmp118 = K866025403 * (tmp109 - tmp108);
	       tmp110 = tmp108 + tmp109;
	       tmp111 = tmp107 + tmp110;
	       tmp113 = tmp107 - (K500000000 * tmp110);
	       tmp84 = c_re(W[0]);
	       tmp104 = c_im(W[0]);
	       X[iostride] = (tmp84 * tmp103) + (tmp104 * tmp111);
	       Y[-7 * iostride] = (tmp84 * tmp111) - (tmp104 * tmp103);
	       {
		    fftw_real tmp121;
		    fftw_real tmp123;
		    fftw_real tmp120;
		    fftw_real tmp122;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp121 = tmp114 + tmp113;
		    tmp123 = tmp117 + tmp118;
		    tmp120 = c_re(W[3]);
		    tmp122 = c_im(W[3]);
		    Y[-4 * iostride] =
			(tmp120 * tmp121) - (tmp122 * tmp123);
		    X[4 * iostride] =
			(tmp122 * tmp121) + (tmp120 * tmp123);
	       }
	       {
		    fftw_real tmp115;
		    fftw_real tmp119;
		    fftw_real tmp112;
		    fftw_real tmp116;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp115 = tmp113 - tmp114;
		    tmp119 = tmp117 - tmp118;
		    tmp112 = c_re(W[6]);
		    tmp116 = c_im(W[6]);
		    Y[-iostride] = (tmp112 * tmp115) - (tmp116 * tmp119);
		    X[7 * iostride] =
			(tmp116 * tmp115) + (tmp112 * tmp119);
	       }
	  }
	  {
	       fftw_real tmp142;
	       fftw_real tmp133;
	       fftw_real tmp145;
	       fftw_real tmp146;
	       fftw_real tmp139;
	       fftw_real tmp141;
	       fftw_real tmp132;
	       fftw_real tmp138;
	       fftw_real tmp124;
	       fftw_real tmp134;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp142 = K866025403 * (tmp131 - tmp128);
	       tmp132 = tmp128 + tmp131;
	       tmp133 = tmp125 + tmp132;
	       tmp145 = tmp125 - (K500000000 * tmp132);
	       tmp146 = K866025403 * (tmp136 + tmp137);
	       tmp138 = tmp136 - tmp137;
	       tmp139 = tmp135 + tmp138;
	       tmp141 = tmp135 - (K500000000 * tmp138);
	       tmp124 = c_re(W[1]);
	       tmp134 = c_im(W[1]);
	       Y[-6 * iostride] = (tmp124 * tmp133) - (tmp134 * tmp139);
	       X[2 * iostride] = (tmp134 * tmp133) + (tmp124 * tmp139);
	       {
		    fftw_real tmp149;
		    fftw_real tmp151;
		    fftw_real tmp148;
		    fftw_real tmp150;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp149 = tmp142 + tmp141;
		    tmp151 = tmp145 + tmp146;
		    tmp148 = c_re(W[4]);
		    tmp150 = c_im(W[4]);
		    X[5 * iostride] =
			(tmp148 * tmp149) + (tmp150 * tmp151);
		    Y[-3 * iostride] =
			(tmp148 * tmp151) - (tmp150 * tmp149);
	       }
	       {
		    fftw_real tmp143;
		    fftw_real tmp147;
		    fftw_real tmp140;
		    fftw_real tmp144;
		    ASSERT_ALIGNED_DOUBLE;
		    tmp143 = tmp141 - tmp142;
		    tmp147 = tmp145 - tmp146;
		    tmp140 = c_re(W[7]);
		    tmp144 = c_im(W[7]);
		    X[8 * iostride] =
			(tmp140 * tmp143) + (tmp144 * tmp147);
		    Y[0] = (tmp140 * tmp147) - (tmp144 * tmp143);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp3;
	  fftw_real tmp37;
	  fftw_real tmp30;
	  fftw_real tmp12;
	  fftw_real tmp11;
	  fftw_real tmp18;
	  fftw_real tmp33;
	  fftw_real tmp7;
	  fftw_real tmp35;
	  fftw_real tmp24;
	  fftw_real tmp21;
	  fftw_real tmp34;
	  fftw_real tmp32;
	  fftw_real tmp15;
	  fftw_real tmp8;
	  fftw_real tmp13;
	  ASSERT_ALIGNED_DOUBLE;
	  {
	       fftw_real tmp29;
	       fftw_real tmp1;
	       fftw_real tmp2;
	       fftw_real tmp27;
	       fftw_real tmp28;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp28 = Y[-iostride];
	       tmp29 = K1_732050807 * tmp28;
	       tmp1 = X[4 * iostride];
	       tmp2 = X[iostride];
	       tmp27 = tmp2 - tmp1;
	       tmp3 = tmp1 + (K2_000000000 * tmp2);
	       tmp37 = tmp27 + tmp29;
	       tmp30 = tmp27 - tmp29;
	  }
	  {
	       fftw_real tmp4;
	       fftw_real tmp6;
	       fftw_real tmp5;
	       fftw_real tmp14;
	       fftw_real tmp16;
	       fftw_real tmp19;
	       fftw_real tmp22;
	       fftw_real tmp10;
	       fftw_real tmp23;
	       fftw_real tmp17;
	       fftw_real tmp9;
	       fftw_real tmp20;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp4 = X[3 * iostride];
	       tmp6 = X[2 * iostride];
	       tmp5 = X[0];
	       tmp14 = K500000000 * (tmp5 + tmp6);
	       tmp16 = K866025403 * (tmp6 - tmp5);
	       tmp19 = K866025403 * (tmp4 - tmp5);
	       tmp22 = K500000000 * (tmp4 + tmp5);
	       tmp9 = Y[-3 * iostride];
	       tmp12 = Y[-2 * iostride];
	       tmp10 = Y[0];
	       tmp11 = tmp9 + tmp10;
	       tmp23 = K866025403 * (tmp10 - tmp9);
	       tmp17 = tmp9 + (K500000000 * (tmp12 - tmp10));
	       tmp18 = tmp16 + tmp17;
	       tmp33 = tmp16 - tmp17;
	       tmp7 = tmp4 + tmp5 + tmp6;
	       tmp35 = (tmp6 + tmp23) - tmp22;
	       tmp24 = tmp22 + tmp23 - tmp6;
	       tmp20 = (K500000000 * tmp11) + tmp12;
	       tmp21 = tmp19 + tmp20;
	       tmp34 = tmp19 - tmp20;
	       tmp32 = tmp4 - (K866025403 * (tmp10 + tmp12)) - tmp14;
	       tmp15 = tmp14 - (K866025403 * (tmp10 + tmp12)) - tmp4;
	  }
	  X[0] = tmp3 + (K2_000000000 * tmp7);
	  tmp8 = tmp7 - tmp3;
	  tmp13 = K1_732050807 * (tmp11 - tmp12);
	  X[3 * iostride] = tmp8 - tmp13;
	  X[6 * iostride] = -(tmp8 + tmp13);
	  {
	       fftw_real tmp25;
	       fftw_real tmp26;
	       fftw_real tmp31;
	       fftw_real tmp38;
	       fftw_real tmp36;
	       fftw_real tmp39;
	       ASSERT_ALIGNED_DOUBLE;
	       tmp25 =
		   (K556670399 * tmp15) + (K663413948 * tmp18) -
		   (K150383733 * tmp21) - (K852868531 * tmp24);
	       tmp26 =
		   (K173648177 * tmp24) + (K766044443 * tmp15) -
		   (K642787609 * tmp18) - (K984807753 * tmp21);
	       tmp31 = (K500000000 * tmp26) - tmp30;
	       X[7 * iostride] = tmp25 - tmp31;
	       X[4 * iostride] = tmp25 + tmp31;
	       X[iostride] = tmp26 + tmp30;
	       tmp38 =
		   (K813797681 * tmp34) + (K852868531 * tmp32) +
		   (K150383733 * tmp33) - (K296198132 * tmp35);
	       tmp36 =
		   (K173648177 * tmp32) - (K984807753 * tmp33) -
		   (K342020143 * tmp34) - (K939692620 * tmp35);
	       tmp39 = (K500000000 * tmp36) + tmp37;
	       X[2 * iostride] = tmp36 - tmp37;
	       X[5 * iostride] = tmp38 + tmp39;
	       X[8 * iostride] = tmp38 - tmp39;
	  }
     }
}

static const int twiddle_order[] = { 1, 2, 3, 4, 5, 6, 7, 8 };
fftw_codelet_desc fftw_hc2hc_backward_9_desc = {
     "fftw_hc2hc_backward_9",
     (void (*)()) fftw_hc2hc_backward_9,
     9,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     212,
     8,
     twiddle_order,
};
